# -*- coding: utf-8 -*-
"""
Created on Tue Jul 10 22:50:32 2018

@author: david
"""

import random
import numpy as np

num_trials = 1000000


def simulate_score(gimmes):
  score = gimmes
  for i in range(0, 6 - gimmes):
    if random.random() < 0.5:
      score += 1
  return score


def calc_gini(x):
  if np.sum(x) == 0:
    return 0
  n = len(x)
  denom = 2*n*np.sum(x)
  numer = 0
  for i in range(n):
    for j in range(n):
      numer += abs(x[i] - x[j])
  
  return numer/denom

out_file = "inequality_ginis.csv"

with open(out_file, "w") as f:
  # Sorry about the hard-coded nested for loops.
  for i1 in range(0, 7):
    for i2 in range(0, i1 + 1):
      for i3 in range(0, i2 + 1):
        for i4 in range(0, i3 + 1):
          for i5 in range(0, i4 + 1):
            for i6 in range(0, i5 + 1):
              gimmes = [i1, i2, i3, i4, i5, i6]
              print(gimmes)
              wins = [0]*6
              
              if gimmes.count(gimmes[0]) != len(gimmes):
                for i_trial in range(num_trials):
                  scores = [0]*6
                  for i_player in range(6):
                    scores[i_player] = simulate_score(gimmes[i_player])
                  
                  max_score = np.max(scores)
                  for i_player in range(6):
                    if scores[i_player] == max_score:
                      wins[i_player] += 1
                
                gini = calc_gini(wins)
              else:
                gini = 0
              
              f.write("{},{},{},{},{},{},{:.4f}\n".format(i1,i2,i3,i4,i5,i6,gini))
